
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MONMISC.C - Miscellaneous User Input Support
// 
//
//   DESCRIPTION
//
//   Functions to process key strokes and obtain input from the user.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MONMISC.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:42   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:35:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:12   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:27:22   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:36   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <bios.h>
#include <graph.h>
#include <conio.h>
#include <string.h>

#ifdef __WATCOMC__
#include <i86.h>
#endif

#include "LABMON.H"
#include "MONMISC.H"

#define peek(addr) (*(unsigned char _far *)addr)

extern char  *Title;
char         tmpbuff[80];
extern short   cmdline;

unsigned long timer(void)
{
 long timer_ticks;
 union REGS regs;

 regs.h.ah = 0;

#ifdef __386__
 int386(0x1A, &regs, &regs);
#else
 int86(0x1A, &regs, &regs);
#endif

#ifdef __WATCOMC__
 timer_ticks = regs.w.cx;
 timer_ticks <<= 16;
 timer_ticks += regs.w.dx;
#else
 timer_ticks = regs.x.cx;
 timer_ticks <<= 16;
 timer_ticks += regs.x.dx;
#endif

 return timer_ticks;
}                                     

//==================================================================

//   author:  Rob Ewing

short getval(char *string, short max)
{
   short    c, i, len, delete_used; 
   char   clrtmp[80];
   struct rccoord CurPos; 
   char   string_sav[80] = {" "};
                              
   len = strlen(string);                             
   CurPos = _gettextposition(); 
   CurPos.col -= len;
   _fmemset(clrtmp, ' ', 80);  
   clrtmp[80-CurPos.col] = '\0';
   strcpy(string_sav, string);  
   delete_used = 0;  
   
   // turn cursor back on
   _settextcursor(0x0707);       
 
   for(i = len; (i <= max) && ((c = getch()) != EOF) && (c != '\r'); i++){
      if(c == 8){    
         // If Delete Key Was Pressed  
         i = i - 2; 
         if(i < -1){
            i = -1;
         }      
         string[i+1] = '\0';
         _settextposition(CurPos.row, CurPos.col);
         _outtext(clrtmp);
         _settextposition(CurPos.row, CurPos.col);
         _outtext(string);
         delete_used = 1;
      }
      else if(c == 27){
         // if escape key was pressed, restore string and exit
         strcpy(string, string_sav);
         i  = 0;   
         // turn cursor back off
         _settextcursor(0x2000);     
         return i;
      }
      else if(c == 0){ 
         // If Extended Key Was Pressed 
         c = getch();
         --i;
      }
      else{    
         // blast default if new data without delete
         if(!delete_used){
            i -= len;
            len = 0;
         }
         string[i] = (char) c;
         string[i+1] = '\0';  
         
         _settextposition(CurPos.row, CurPos.col);
         _outtext(string); 
      }
   } 
   // last char must be a null
   string[i] = '\0'; 
   
   // turn cursor back off and return number chars read
   _settextcursor(0x2000);
   return i; 
}
 
//=====================================================================

short ask_short(char *text, short val, short *valid)
{
   short i = 0;
 
   _outtext(text); 
   flush_keys();     
   if(val != ' '){
      sprintf(tmpbuff, "%d", val); 
      _outtext(tmpbuff);
   }
   else{
      sprintf(tmpbuff, "\0");  
   }
   *valid = getval(tmpbuff, 80);
   sscanf(tmpbuff, "%d", &i);
   return i;
} 
 

char ask_char(char *text, char cval, short *valid)
{
   char i;
      
   _outtext(text);  
   flush_keys();     
   if(cval != ' '){
      sprintf(tmpbuff, "%c", cval); 
      _outtext(tmpbuff);
   }
   else{
      sprintf(tmpbuff, "\0");    
   }
   *valid = getval(tmpbuff, 1);      
   sscanf(tmpbuff, "%c", &i);
   return i;
} 

void ask_str(char *text, char *cval, short *valid)
{     
   _outtext(text);  
   flush_keys();  
 
   if(cval[0] != ' '){
      sprintf(tmpbuff, "%s", cval);
      _outtext(tmpbuff); 
   } 
   else{
      sprintf(tmpbuff, "\0");    
   }
   *valid = getval(tmpbuff, 80);      
   sscanf(tmpbuff, "%s", cval);   
}

double ask_dbl(char *text, double val, short *valid)
{    
   double i = 0;   
   
   _outtext(text);
   flush_keys();   
   if(val != ' '){
      sprintf(tmpbuff, "%f", val); 
      _outtext(tmpbuff); 
   }
   else{
      sprintf(tmpbuff, "\0");    
   }
   *valid = getval(tmpbuff, 80);
   sscanf(tmpbuff, "%lf", &i);
   return i;
}

float ask_float(char *text, float val, short *valid)
{
   float i = 0.0f;
       
   _outtext(text);
   flush_keys();   
   if(val != ' '){
      sprintf(tmpbuff, "%f", val); 
     _outtext(tmpbuff);
   }
   else{
      sprintf(tmpbuff, "\0");   
   }
   *valid = getval(tmpbuff, 80);
   sscanf(tmpbuff, "%f", &i);
   return i;
}

long ask_long(char *text, long val, short *valid)
{
   long i = 0l;
      
   _outtext(text);
   flush_keys();   
   if(val != ' '){
      sprintf(tmpbuff, "%ld", val);  
      _outtext(tmpbuff);
   }
   else{
      sprintf(tmpbuff, "\0");   
   }
   *valid = getval(tmpbuff, 80);
   sscanf(tmpbuff, "%ld", &i);
   return i;
}

short ask_hex(char *text, short val, short *valid)
{
   short i = 0;
 
   _outtext(text);
   flush_keys();   
   if(val != ' '){
      sprintf(tmpbuff, "%x", val); 
      _outtext(tmpbuff);
   }
   else{
      sprintf(tmpbuff, "\0");   
   }
   *valid = getval(tmpbuff, 80);
   sscanf(tmpbuff, "%x", &i);
   return i;
}

void clear_message_line(void)
{  
    extern char *Clear80[81];
   
   _settextposition(cmdline,1);
   _outtext(*Clear80);  
   _settextposition(cmdline,1);
}

void clear_command_line(void)
{  
    extern char *Clear80[81];
   
   _settextposition(cmdline-1,1);
   _outtext(*Clear80);  
   _settextposition(cmdline-1,1);
}

void flush_keys(void)
{
   while(kbhit()){
      getch();
   }
}

KeyboardType getkey(short Type)
{
   KeyboardType kb; /* Structure Used For Keyboard Input */
   short kread = _KEYBRD_READ;
   short kready = _KEYBRD_READY;
   short kshiftstatus = _KEYBRD_SHIFTSTATUS;

   /* If Bit 4 Of The Byte At 0x0040:0x0096 Is Set, */
   /* The New Keyboard Is Present */

   if(peek(0x00400096) & 0x10){
      kread = _NKEYBRD_READ;
      kready = _NKEYBRD_READY;
      kshiftstatus = _NKEYBRD_SHIFTSTATUS;
   }

   if(Type)                    /* IF 'Type' != 0 then clear buffer */
   while(_bios_keybrd(kready)) /* Continue To Read Until Empty */
    _bios_keybrd(kread);

   kb.key   = _bios_keybrd(kread);        /* Get Key */
   kb.shift = _bios_keybrd(kshiftstatus); /* Get Shift State */
   kb.scan  = kb.key >> 8;                /* Get Scan Code From Key */
   kb.ascii = kb.key & 0x00ff;            /* Get ASCII Code From Key */

   return(kb);
}




